/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.security.internal.linux;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.security.internal.linux.Messages;
import com.aptana.ide.security.internal.linux.StorageLoginDialog;
import com.aptana.ide.security.linux.Activator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class PasswordProvider
extends org.eclipse.equinox.security.storage.provider.PasswordProvider {
    private static final String ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String ENCODING = "UTF-8";
    private static final int BYTE_ARRAY_SIZE = 1024;
    private String accountName = System.getProperty("user.home");

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        String password;
        block8: {
            boolean passwordChange;
            boolean newPassword;
            block7: {
                if (this.accountName == null) {
                    return null;
                }
                newPassword = (passwordType & 1) != 0;
                passwordChange = (passwordType & 2) != 0;
                try {
                    char[] existing;
                    if (!newPassword && !passwordChange && (existing = this.getPassword()) != null && existing.length != 0) {
                        return new PBEKeySpec(existing);
                    }
                    if (PasswordProvider.useUI()) break block7;
                    return null;
                }
                catch (IOException e) {
                    Activator.logError(e);
                    return null;
                }
            }
            Object prompt = container.getOption((Object)"org.eclipse.equinox.security.storage.promptUser");
            if (prompt != null && !Boolean.parseBoolean(prompt.toString())) {
                return new PBEKeySpec(new char[0]);
            }
            final String[] result = new String[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    StorageLoginDialog loginDialog = new StorageLoginDialog(Display.getDefault().getActiveShell(), newPassword, passwordChange);
                    result[0] = loginDialog.open() == 0 ? loginDialog.getPassword() : null;
                }
            });
            password = result[0];
            if (password != null && password.trim().length() != 0) break block8;
            return null;
        }
        this.writePassword(password);
        return new PBEKeySpec(password.toCharArray());
    }

    private static boolean useUI() {
        return PlatformUI.isWorkbenchRunning();
    }

    private void writePassword(String password) throws IOException {
        SecretKeySpec key = this.getKeySpec();
        byte[] encrypted = this.encrypt(key, password);
        if (encrypted != null && encrypted.length > 0) {
            byte[] b64 = Base64.encode((byte[])encrypted);
            PasswordProvider.write(b64, new FileOutputStream(this.getPasswordFile()));
        }
    }

    private char[] getPassword() throws IOException {
        byte[] encrypted = this.getEncryptedPassword();
        if (encrypted == null) {
            return new char[0];
        }
        byte[] bytes = Base64.decode((byte[])encrypted);
        if (bytes != null) {
            SecretKeySpec key = this.getKeySpec();
            byte[] decrypted = this.decrypt(key, bytes);
            if (decrypted == null || decrypted.length == 0) {
                return new char[0];
            }
            return new String(decrypted, ENCODING).toCharArray();
        }
        return new char[0];
    }

    private byte[] getEncryptedPassword() throws IOException {
        File file = this.getPasswordFile();
        if (!file.exists()) {
            return null;
        }
        return PasswordProvider.read(new FileInputStream(file), ENCODING);
    }

    private File getPasswordFile() throws IOException {
        File file = new File(String.valueOf(this.accountName) + File.separator + ".aptanasecure", ".store");
        file.getParentFile().mkdirs();
        return file;
    }

    private SecretKeySpec getKeySpec() {
        String ksPref = Platform.getPreferencesService().getString("com.aptana.ide.security.linux", "cachedKey", "", null);
        byte[] key = null;
        if (!"".equals(ksPref)) {
            try {
                byte[] bytes = Base64.decode((byte[])ksPref.getBytes(ENCODING));
                if (bytes != null) {
                    key = bytes;
                }
            }
            catch (Exception e) {
                Activator.logError(Messages.PasswordProvider_ERR_UnableToDecodeExistingKey, e);
            }
        }
        if (key == null || key.length == 0) {
            try {
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(128);
                SecretKey skey = kgen.generateKey();
                key = skey.getEncoded();
                byte[] b64 = Base64.encode((byte[])skey.getEncoded());
                IEclipsePreferences node = InstanceScope.INSTANCE.getNode("com.aptana.ide.security.linux");
                node.put("cachedKey", new String(b64));
                node.flush();
            }
            catch (NoSuchAlgorithmException e) {
                Activator.logError(Messages.PasswordProvider_ERR_NoSuchAlgorithm, e);
                return null;
            }
            catch (BackingStoreException e) {
                Activator.logError(Messages.PasswordProvider_ERR_UnableToStoreKey, (Exception)((Object)e));
                return null;
            }
        }
        return new SecretKeySpec(key, "AES");
    }

    private byte[] encrypt(SecretKeySpec skeySpec, String password) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, skeySpec);
            return cipher.doFinal(password.getBytes(ENCODING));
        }
        catch (NoSuchAlgorithmException e) {
            Activator.logError(Messages.PasswordProvider_ERR_NoSuchAlgorithm, e);
        }
        catch (NoSuchPaddingException e) {
            Activator.logError(Messages.PasswordProvider_ERR_NoSuchPadding, e);
        }
        catch (InvalidKeyException e) {
            Activator.logError(Messages.PasswordProvider_ERR_InvalidKey, e);
        }
        catch (IllegalBlockSizeException e) {
            Activator.logError(Messages.PasswordProvider_ERR_IllegalBlockSize, e);
        }
        catch (BadPaddingException e) {
            IdeLog.logWarning((Plugin)Activator.getDefault(), (String)Messages.PasswordProvider_ERR_BadPadding, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            Activator.logError(Messages.PasswordProvider_ERR_UnsupportedEncoding, e);
        }
        return null;
    }

    private byte[] decrypt(SecretKeySpec skeySpec, byte[] encryptedPassword) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, skeySpec);
            return cipher.doFinal(encryptedPassword);
        }
        catch (NoSuchAlgorithmException e) {
            Activator.logError(Messages.PasswordProvider_ERR_NoSuchAlgorithm, e);
        }
        catch (NoSuchPaddingException e) {
            Activator.logError(Messages.PasswordProvider_ERR_NoSuchPadding, e);
        }
        catch (InvalidKeyException e) {
            Activator.logError(Messages.PasswordProvider_ERR_InvalidKey, e);
        }
        catch (IllegalBlockSizeException e) {
            Activator.logError(Messages.PasswordProvider_ERR_IllegalBlockSize, e);
        }
        catch (BadPaddingException e) {
            IdeLog.logWarning((Plugin)Activator.getDefault(), (String)Messages.PasswordProvider_ERR_BadPadding, (Throwable)e);
        }
        return null;
    }

    private static byte[] read(InputStream stream, String charset) {
        if (stream == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            int len;
            if (!(stream instanceof BufferedInputStream)) {
                stream = new BufferedInputStream(stream);
            }
            byte[] buffer = new byte[1024];
            while ((len = stream.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            Activator.logError(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static void write(byte[] bytes, OutputStream stream) {
        try {
            try {
                stream.write(bytes);
            }
            catch (IOException e) {
                Activator.logError(e);
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

